//===============================================================================
// Microsoft patterns & practices Enterprise Library
// Configuration Application Block
//===============================================================================
// Copyright  Microsoft Corporation.  All rights reserved.
// THIS CODE AND INFORMATION IS PROVIDED "AS IS" WITHOUT WARRANTY
// OF ANY KIND, EITHER EXPRESSED OR IMPLIED, INCLUDING BUT NOT
// LIMITED TO THE IMPLIED WARRANTIES OF MERCHANTABILITY AND
// FITNESS FOR A PARTICULAR PURPOSE.
//===============================================================================

using System;
using Microsoft.VisualStudio.QualityTools.UnitTesting.Framework;
using Microsoft.Practices.EnterpriseLibrary.Configuration.Factory;

namespace Microsoft.Practices.EnterpriseLibrary.Configuration.Injection.Tests
{
	[TestClass]
	public class AnonymousObjectInjectionFactoryFixture
	{
		[TestMethod]
		public void CreateASimpleObject()
		{
			SimpleObject obj = new SimpleObjectFactory().Create();

			Assert.IsNotNull(obj);
			Assert.AreEqual<string>("bob", obj.Name);
		}

		[TestMethod]
		public void CreateASimpleObjectThroughTheInterface()
		{
            IObjectFactory<SimpleObject, SimpleObjectConfiguration> factory = new SimpleObjectFactory();
			SimpleObject obj = (SimpleObject)factory.Create(null);

			Assert.IsNotNull(obj);
			Assert.AreEqual<string>("bob", obj.Name);
		}

		class SimpleObjectFactory : InjectionFactory<SimpleObject, SimpleObjectConfiguration>
		{
            protected override SimpleObjectConfiguration GetConfiguration(SimpleObjectConfiguration configuration, IConfigurationSource configurationSource)
			{
				return new SimpleObjectConfiguration("bob");
			}
		}
		
	}
}
